# makefile for panorama stitching, created by hugin 



# Tool configuration
NONA=C:\Program\ Files\Hugin\bin\nona
PTSTITCHER=PTStitcher
PTMENDER=C:\Program\ Files\Hugin\bin\PTmender
PTBLENDER=C:\Program\ Files\Hugin\bin\PTblender
PTMASKER=C:\Program\ Files\Hugin\bin\PTmasker
PTROLLER=C:\Program\ Files\Hugin\bin\PTroller
ENBLEND=C:\Program\ Files\Hugin\bin\enblend
ENFUSE=C:\Program\ Files\Hugin\bin\enfuse
SMARTBLEND=smartblend.exe
HDRMERGE=C:\Program\ Files\Hugin\bin\hugin_hdrmerge
RM=rm
EXIFTOOL=C:\Program\ Files\Hugin\bin\exiftool

# options for the programs

NONA_LDR_REMAPPED_COMP=-z PACKBITS 
ENBLEND_OPTS= -f6440x1960
ENBLEND_LDR_COMP=--compression 100
ENBLEND_HDR_COMP=
ENFUSE_OPTS=
EXIFTOOL_COPY_ARGS=-ImageDescription -Make -Model -Artist -WhitePoint -Copyright -GPS:all -DateTimeOriginal -CreateDate -UserComment -ColorSpace -OwnerName -SerialNumber

# the output panorama
LDR_REMAPPED_PREFIX=Chamonix2008\ 129-Chamonix2008\ 132
LDR_REMAPPED_PREFIX_SHELL=Chamonix2008\ 129-Chamonix2008\ 132
HDR_STACK_REMAPPED_PREFIX=Chamonix2008\ 129-Chamonix2008\ 132_hdr_
HDR_STACK_REMAPPED_PREFIX_SHELL=Chamonix2008\ 129-Chamonix2008\ 132_hdr_
LDR_EXPOSURE_REMAPPED_PREFIX=Chamonix2008\ 129-Chamonix2008\ 132_exposure_layers_
LDR_EXPOSURE_REMAPPED_PREFIX_SHELL=Chamonix2008\ 129-Chamonix2008\ 132_exposure_layers_
PROJECT_FILE=C:\Documents\ and\ Settings\Petan\Dokumenty\Obrzky\Chamonix2008\Ja\Chamonix2008\ 129-Chamonix2008\ 132.pto
PROJECT_FILE_SHELL=C:\Documents\ and\ Settings\Petan\Dokumenty\Obrzky\Chamonix2008\Ja\Chamonix2008\ 129-Chamonix2008\ 132.pto
LDR_BLENDED=Chamonix2008\ 129-Chamonix2008\ 132.jpg
LDR_BLENDED_SHELL=Chamonix2008\ 129-Chamonix2008\ 132.jpg
LDR_STACKED_BLENDED=Chamonix2008\ 129-Chamonix2008\ 132_fused.jpg
LDR_STACKED_BLENDED_SHELL=Chamonix2008\ 129-Chamonix2008\ 132_fused.jpg
HDR_BLENDED=Chamonix2008\ 129-Chamonix2008\ 132_hdr.exr
HDR_BLENDED_SHELL=Chamonix2008\ 129-Chamonix2008\ 132_hdr.exr

# first input image
INPUT_IMAGE_1=C:\Documents\ and\ Settings\Petan\Dokumenty\Obrzky\Chamonix2008\Ja\Chamonix2008\ 129.jpg
INPUT_IMAGE_1_SHELL=C:\Documents\ and\ Settings\Petan\Dokumenty\Obrzky\Chamonix2008\Ja\Chamonix2008\ 129.jpg
# all input images
INPUT_IMAGES=C:\Documents\ and\ Settings\Petan\Dokumenty\Obrzky\Chamonix2008\Ja\Chamonix2008\ 129.jpg\
C:\Documents\ and\ Settings\Petan\Dokumenty\Obrzky\Chamonix2008\Ja\Chamonix2008\ 130.jpg\
C:\Documents\ and\ Settings\Petan\Dokumenty\Obrzky\Chamonix2008\Ja\Chamonix2008\ 131.jpg\
C:\Documents\ and\ Settings\Petan\Dokumenty\Obrzky\Chamonix2008\Ja\Chamonix2008\ 132.jpg

INPUT_IMAGES_SHELL=C:\Documents\ and\ Settings\Petan\Dokumenty\Obrzky\Chamonix2008\Ja\Chamonix2008\ 129.jpg\
C:\Documents\ and\ Settings\Petan\Dokumenty\Obrzky\Chamonix2008\Ja\Chamonix2008\ 130.jpg\
C:\Documents\ and\ Settings\Petan\Dokumenty\Obrzky\Chamonix2008\Ja\Chamonix2008\ 131.jpg\
C:\Documents\ and\ Settings\Petan\Dokumenty\Obrzky\Chamonix2008\Ja\Chamonix2008\ 132.jpg

# remapped images
LDR_LAYERS=Chamonix2008\ 129-Chamonix2008\ 1320000.tif\
Chamonix2008\ 129-Chamonix2008\ 1320001.tif\
Chamonix2008\ 129-Chamonix2008\ 1320002.tif\
Chamonix2008\ 129-Chamonix2008\ 1320003.tif

LDR_LAYERS_SHELL=Chamonix2008\ 129-Chamonix2008\ 1320000.tif\
Chamonix2008\ 129-Chamonix2008\ 1320001.tif\
Chamonix2008\ 129-Chamonix2008\ 1320002.tif\
Chamonix2008\ 129-Chamonix2008\ 1320003.tif

# remapped images (hdr)
HDR_LAYERS=Chamonix2008\ 129-Chamonix2008\ 132_hdr_0000.exr\
Chamonix2008\ 129-Chamonix2008\ 132_hdr_0001.exr\
Chamonix2008\ 129-Chamonix2008\ 132_hdr_0002.exr\
Chamonix2008\ 129-Chamonix2008\ 132_hdr_0003.exr

HDR_LAYERS_SHELL=Chamonix2008\ 129-Chamonix2008\ 132_hdr_0000.exr\
Chamonix2008\ 129-Chamonix2008\ 132_hdr_0001.exr\
Chamonix2008\ 129-Chamonix2008\ 132_hdr_0002.exr\
Chamonix2008\ 129-Chamonix2008\ 132_hdr_0003.exr

# remapped maxval images
HDR_LAYERS_WEIGHTS=Chamonix2008\ 129-Chamonix2008\ 132_hdr_0000_gray.pgm \
Chamonix2008\ 129-Chamonix2008\ 132_hdr_0001_gray.pgm \
Chamonix2008\ 129-Chamonix2008\ 132_hdr_0002_gray.pgm \
Chamonix2008\ 129-Chamonix2008\ 132_hdr_0003_gray.pgm 

HDR_LAYERS_WEIGHTS_SHELL=Chamonix2008\ 129-Chamonix2008\ 132_hdr_0000_gray.pgm\
Chamonix2008\ 129-Chamonix2008\ 132_hdr_0001_gray.pgm\
Chamonix2008\ 129-Chamonix2008\ 132_hdr_0002_gray.pgm\
Chamonix2008\ 129-Chamonix2008\ 132_hdr_0003_gray.pgm

# stacked images
HDR_STACKS_NUMBERS = 0 1 2 3 
HDR_STACK_0 = Chamonix2008\ 129-Chamonix2008\ 132_stack_hdr_0000.exr
HDR_STACK_0_SHELL = Chamonix2008\ 129-Chamonix2008\ 132_stack_hdr_0000.exr
HDR_STACK_0_INPUT = Chamonix2008\ 129-Chamonix2008\ 132_hdr_0000.exr

HDR_STACK_0_INPUT_SHELL = Chamonix2008\ 129-Chamonix2008\ 132_hdr_0000.exr

HDR_STACK_1 = Chamonix2008\ 129-Chamonix2008\ 132_stack_hdr_0001.exr
HDR_STACK_1_SHELL = Chamonix2008\ 129-Chamonix2008\ 132_stack_hdr_0001.exr
HDR_STACK_1_INPUT = Chamonix2008\ 129-Chamonix2008\ 132_hdr_0001.exr

HDR_STACK_1_INPUT_SHELL = Chamonix2008\ 129-Chamonix2008\ 132_hdr_0001.exr

HDR_STACK_2 = Chamonix2008\ 129-Chamonix2008\ 132_stack_hdr_0002.exr
HDR_STACK_2_SHELL = Chamonix2008\ 129-Chamonix2008\ 132_stack_hdr_0002.exr
HDR_STACK_2_INPUT = Chamonix2008\ 129-Chamonix2008\ 132_hdr_0002.exr

HDR_STACK_2_INPUT_SHELL = Chamonix2008\ 129-Chamonix2008\ 132_hdr_0002.exr

HDR_STACK_3 = Chamonix2008\ 129-Chamonix2008\ 132_stack_hdr_0003.exr
HDR_STACK_3_SHELL = Chamonix2008\ 129-Chamonix2008\ 132_stack_hdr_0003.exr
HDR_STACK_3_INPUT = Chamonix2008\ 129-Chamonix2008\ 132_hdr_0003.exr

HDR_STACK_3_INPUT_SHELL = Chamonix2008\ 129-Chamonix2008\ 132_hdr_0003.exr


HDR_STACKS = $(HDR_STACK_0) $(HDR_STACK_1) $(HDR_STACK_2) $(HDR_STACK_3) 
HDR_STACKS_SHELL = $(HDR_STACK_0_SHELL) $(HDR_STACK_1_SHELL) $(HDR_STACK_2_SHELL) $(HDR_STACK_3_SHELL) 


# number of image sets with similar exposure
LDR_EXPOSURE_EXPOSURE_LAYERS_NUMBERS = 0 
LDR_EXPOSURE_LAYER_0 = Chamonix2008\ 129-Chamonix2008\ 132_exposure_00.jpg
LDR_EXPOSURE_LAYER_0_SHELL = Chamonix2008\ 129-Chamonix2008\ 132_exposure_00.jpg
LDR_EXPOSURE_LAYER_0_INPUT = Chamonix2008\ 129-Chamonix2008\ 132_exposure_layers_0000.tif\
Chamonix2008\ 129-Chamonix2008\ 132_exposure_layers_0001.tif\
Chamonix2008\ 129-Chamonix2008\ 132_exposure_layers_0002.tif\
Chamonix2008\ 129-Chamonix2008\ 132_exposure_layers_0003.tif

LDR_EXPOSURE_LAYER_0_INPUT_SHELL = Chamonix2008\ 129-Chamonix2008\ 132_exposure_layers_0000.tif\
Chamonix2008\ 129-Chamonix2008\ 132_exposure_layers_0001.tif\
Chamonix2008\ 129-Chamonix2008\ 132_exposure_layers_0002.tif\
Chamonix2008\ 129-Chamonix2008\ 132_exposure_layers_0003.tif

LDR_EXPOSURE_LAYER_0_INPUT_PTMENDER = Chamonix2008\ 129-Chamonix2008\ 1320000.tif\
Chamonix2008\ 129-Chamonix2008\ 1320001.tif\
Chamonix2008\ 129-Chamonix2008\ 1320002.tif\
Chamonix2008\ 129-Chamonix2008\ 1320003.tif

LDR_EXPOSURE_LAYER_0_INPUT_PTMENDER_SHELL = Chamonix2008\ 129-Chamonix2008\ 1320000.tif\
Chamonix2008\ 129-Chamonix2008\ 1320001.tif\
Chamonix2008\ 129-Chamonix2008\ 1320002.tif\
Chamonix2008\ 129-Chamonix2008\ 1320003.tif
LDR_EXPOSURE_LAYER_0_EXPOSURE = 28.6113

LDR_EXPOSURE_LAYERS = $(LDR_EXPOSURE_LAYER_0) 
LDR_EXPOSURE_LAYERS_SHELL = $(LDR_EXPOSURE_LAYER_0_SHELL) 
LDR_EXPOSURE_LAYERS_REMAPPED = Chamonix2008\ 129-Chamonix2008\ 132_exposure_layers_0000.tif\
Chamonix2008\ 129-Chamonix2008\ 132_exposure_layers_0001.tif\
Chamonix2008\ 129-Chamonix2008\ 132_exposure_layers_0002.tif\
Chamonix2008\ 129-Chamonix2008\ 132_exposure_layers_0003.tif

LDR_EXPOSURE_LAYERS_REMAPPED_SHELL = Chamonix2008\ 129-Chamonix2008\ 132_exposure_layers_0000.tif\
Chamonix2008\ 129-Chamonix2008\ 132_exposure_layers_0001.tif\
Chamonix2008\ 129-Chamonix2008\ 132_exposure_layers_0002.tif\
Chamonix2008\ 129-Chamonix2008\ 132_exposure_layers_0003.tif


# stacked images for enfuse or other automatic exposure blending tools
LDR_STACKS_NUMBERS = 0 1 2 3 
LDR_STACK_0 = Chamonix2008\ 129-Chamonix2008\ 132_stack_ldr_0000.tif
LDR_STACK_0_SHELL = Chamonix2008\ 129-Chamonix2008\ 132_stack_ldr_0000.tif
LDR_STACK_0_INPUT = Chamonix2008\ 129-Chamonix2008\ 132_exposure_layers_0000.tif

LDR_STACK_0_INPUT_SHELL = Chamonix2008\ 129-Chamonix2008\ 132_exposure_layers_0000.tif

LDR_STACK_1 = Chamonix2008\ 129-Chamonix2008\ 132_stack_ldr_0001.tif
LDR_STACK_1_SHELL = Chamonix2008\ 129-Chamonix2008\ 132_stack_ldr_0001.tif
LDR_STACK_1_INPUT = Chamonix2008\ 129-Chamonix2008\ 132_exposure_layers_0001.tif

LDR_STACK_1_INPUT_SHELL = Chamonix2008\ 129-Chamonix2008\ 132_exposure_layers_0001.tif

LDR_STACK_2 = Chamonix2008\ 129-Chamonix2008\ 132_stack_ldr_0002.tif
LDR_STACK_2_SHELL = Chamonix2008\ 129-Chamonix2008\ 132_stack_ldr_0002.tif
LDR_STACK_2_INPUT = Chamonix2008\ 129-Chamonix2008\ 132_exposure_layers_0002.tif

LDR_STACK_2_INPUT_SHELL = Chamonix2008\ 129-Chamonix2008\ 132_exposure_layers_0002.tif

LDR_STACK_3 = Chamonix2008\ 129-Chamonix2008\ 132_stack_ldr_0003.tif
LDR_STACK_3_SHELL = Chamonix2008\ 129-Chamonix2008\ 132_stack_ldr_0003.tif
LDR_STACK_3_INPUT = Chamonix2008\ 129-Chamonix2008\ 132_exposure_layers_0003.tif

LDR_STACK_3_INPUT_SHELL = Chamonix2008\ 129-Chamonix2008\ 132_exposure_layers_0003.tif


LDR_STACKS = $(LDR_STACK_0) $(LDR_STACK_1) $(LDR_STACK_2) $(LDR_STACK_3) 
LDR_STACKS_SHELL = $(LDR_STACK_0_SHELL) $(LDR_STACK_1_SHELL) $(LDR_STACK_2_SHELL) $(LDR_STACK_3_SHELL) 
TEMP_FILES_SHELL = 

all: $(LDR_BLENDED) $(LDR_LAYERS) 

clean: 
	-$(RM) $(TEMP_FILES_SHELL)

# Rules for ordinary TIFF_m output
Chamonix2008\ 129-Chamonix2008\ 1320000.tif: C:\Documents\ and\ Settings\Petan\Dokumenty\Obrzky\Chamonix2008\Ja\Chamonix2008\ 129.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -m TIFF_m -o $(LDR_REMAPPED_PREFIX_SHELL) -i 0 $(PROJECT_FILE_SHELL)

Chamonix2008\ 129-Chamonix2008\ 1320001.tif: C:\Documents\ and\ Settings\Petan\Dokumenty\Obrzky\Chamonix2008\Ja\Chamonix2008\ 130.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -m TIFF_m -o $(LDR_REMAPPED_PREFIX_SHELL) -i 1 $(PROJECT_FILE_SHELL)

Chamonix2008\ 129-Chamonix2008\ 1320002.tif: C:\Documents\ and\ Settings\Petan\Dokumenty\Obrzky\Chamonix2008\Ja\Chamonix2008\ 131.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -m TIFF_m -o $(LDR_REMAPPED_PREFIX_SHELL) -i 2 $(PROJECT_FILE_SHELL)

Chamonix2008\ 129-Chamonix2008\ 1320003.tif: C:\Documents\ and\ Settings\Petan\Dokumenty\Obrzky\Chamonix2008\Ja\Chamonix2008\ 132.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -m TIFF_m -o $(LDR_REMAPPED_PREFIX_SHELL) -i 3 $(PROJECT_FILE_SHELL)

# Rules for merge to hdr output
Chamonix2008\ 129-Chamonix2008\ 132_hdr_0000.exr: C:\Documents\ and\ Settings\Petan\Dokumenty\Obrzky\Chamonix2008\Ja\Chamonix2008\ 129.jpg $(PROJECT_FILE)
	$(NONA) -r hdr -m EXR_m -o $(HDR_STACK_REMAPPED_PREFIX_SHELL) -i 0 $(PROJECT_FILE_SHELL)

Chamonix2008\ 129-Chamonix2008\ 132_hdr_0001.exr: C:\Documents\ and\ Settings\Petan\Dokumenty\Obrzky\Chamonix2008\Ja\Chamonix2008\ 130.jpg $(PROJECT_FILE)
	$(NONA) -r hdr -m EXR_m -o $(HDR_STACK_REMAPPED_PREFIX_SHELL) -i 1 $(PROJECT_FILE_SHELL)

Chamonix2008\ 129-Chamonix2008\ 132_hdr_0002.exr: C:\Documents\ and\ Settings\Petan\Dokumenty\Obrzky\Chamonix2008\Ja\Chamonix2008\ 131.jpg $(PROJECT_FILE)
	$(NONA) -r hdr -m EXR_m -o $(HDR_STACK_REMAPPED_PREFIX_SHELL) -i 2 $(PROJECT_FILE_SHELL)

Chamonix2008\ 129-Chamonix2008\ 132_hdr_0003.exr: C:\Documents\ and\ Settings\Petan\Dokumenty\Obrzky\Chamonix2008\Ja\Chamonix2008\ 132.jpg $(PROJECT_FILE)
	$(NONA) -r hdr -m EXR_m -o $(HDR_STACK_REMAPPED_PREFIX_SHELL) -i 3 $(PROJECT_FILE_SHELL)

# Rules for exposure layer output
Chamonix2008\ 129-Chamonix2008\ 132_exposure_layers_0000.tif: C:\Documents\ and\ Settings\Petan\Dokumenty\Obrzky\Chamonix2008\Ja\Chamonix2008\ 129.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -e 14.3056 -m TIFF_m -o $(LDR_EXPOSURE_REMAPPED_PREFIX_SHELL) -i 0 $(PROJECT_FILE_SHELL)

Chamonix2008\ 129-Chamonix2008\ 132_exposure_layers_0001.tif: C:\Documents\ and\ Settings\Petan\Dokumenty\Obrzky\Chamonix2008\Ja\Chamonix2008\ 130.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -e 14.3056 -m TIFF_m -o $(LDR_EXPOSURE_REMAPPED_PREFIX_SHELL) -i 1 $(PROJECT_FILE_SHELL)

Chamonix2008\ 129-Chamonix2008\ 132_exposure_layers_0002.tif: C:\Documents\ and\ Settings\Petan\Dokumenty\Obrzky\Chamonix2008\Ja\Chamonix2008\ 131.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -e 14.3056 -m TIFF_m -o $(LDR_EXPOSURE_REMAPPED_PREFIX_SHELL) -i 2 $(PROJECT_FILE_SHELL)

Chamonix2008\ 129-Chamonix2008\ 132_exposure_layers_0003.tif: C:\Documents\ and\ Settings\Petan\Dokumenty\Obrzky\Chamonix2008\Ja\Chamonix2008\ 132.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -e 14.3056 -m TIFF_m -o $(LDR_EXPOSURE_REMAPPED_PREFIX_SHELL) -i 3 $(PROJECT_FILE_SHELL)

$(HDR_STACK_0) : $(HDR_STACK_0_INPUT)
	$(HDRMERGE) -m avg -c -o $(HDR_STACK_0_SHELL) $(HDR_STACK_0_INPUT_SHELL)

$(HDR_STACK_1) : $(HDR_STACK_1_INPUT)
	$(HDRMERGE) -m avg -c -o $(HDR_STACK_1_SHELL) $(HDR_STACK_1_INPUT_SHELL)

$(HDR_STACK_2) : $(HDR_STACK_2_INPUT)
	$(HDRMERGE) -m avg -c -o $(HDR_STACK_2_SHELL) $(HDR_STACK_2_INPUT_SHELL)

$(HDR_STACK_3) : $(HDR_STACK_3_INPUT)
	$(HDRMERGE) -m avg -c -o $(HDR_STACK_3_SHELL) $(HDR_STACK_3_INPUT_SHELL)

$(LDR_STACK_0) : $(LDR_STACK_0_INPUT)
	$(ENFUSE) $(ENFUSE_OPTS) -o $(LDR_STACK_0_SHELL) $(LDR_STACK_0_INPUT_SHELL)
	$(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACK_0_SHELL)

$(LDR_STACK_1) : $(LDR_STACK_1_INPUT)
	$(ENFUSE) $(ENFUSE_OPTS) -o $(LDR_STACK_1_SHELL) $(LDR_STACK_1_INPUT_SHELL)
	$(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACK_1_SHELL)

$(LDR_STACK_2) : $(LDR_STACK_2_INPUT)
	$(ENFUSE) $(ENFUSE_OPTS) -o $(LDR_STACK_2_SHELL) $(LDR_STACK_2_INPUT_SHELL)
	$(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACK_2_SHELL)

$(LDR_STACK_3) : $(LDR_STACK_3_INPUT)
	$(ENFUSE) $(ENFUSE_OPTS) -o $(LDR_STACK_3_SHELL) $(LDR_STACK_3_INPUT_SHELL)
	$(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACK_3_SHELL)

$(LDR_BLENDED) : $(LDR_LAYERS)
	$(ENBLEND) $(ENBLEND_LDR_COMP) $(ENBLEND_OPTS) -o $(LDR_BLENDED_SHELL) $(LDR_LAYERS_SHELL) 
	$(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_BLENDED_SHELL)

$(LDR_EXPOSURE_LAYER_0) : $(LDR_EXPOSURE_LAYER_0_INPUT)
	$(ENBLEND) $(ENBLEND_LDR_COMP) $(ENBLEND_OPTS) -o $(LDR_EXPOSURE_LAYER_0_SHELL) $(LDR_EXPOSURE_LAYER_0_INPUT_SHELL)
	$(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_EXPOSURE_LAYER_0_SHELL)

$(LDR_STACKED_BLENDED) : $(LDR_STACKS)
	$(ENBLEND) $(ENBLEND_LDR_COMP) $(ENBLEND_OPTS) -o $(LDR_STACKED_BLENDED_SHELL) $(LDR_STACKS_SHELL) 
	$(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACKED_BLENDED_SHELL)

$(HDR_BLENDED) : $(HDR_STACKS)
	$(ENBLEND) $(ENBLEND_HDR_COMP) $(ENBLEND_OPTS) -o $(HDR_BLENDED_SHELL) $(HDR_STACKS_SHELL) 

